local square = extra.square
local triangle = extra.triangle
local function get_rod(n)
  local ret = {}
  for i = 5 - n, 4 do
    table.insert(ret, Place.new(CellView.new(Vector.new(i, 0)), Basic.new(2)))
  end
  for i = 5 - n + 1, 4 do
    table.insert(ret, Join.new(CellFace.new(Vector.new(i, 0), LEFT)))
  end
  return ret
end
local get_next_input = coroutine.wrap(function()
  local ct = 0
  while true do
    for i = 1, get_value(ct) do
      coroutine.yield(square)
    end
    coroutine.yield(triangle)
    ct = ct + 1
  end
end)
local get_next_in_out = coroutine.wrap(function()
  local ct = 0
  while true do
    for i = 1, get_value(ct) do
      coroutine.yield(square)
    end
    coroutine.yield(triangle)
    ct = ct + 1
  end
end)
location.std.generators[2].dynamic = function(_)
  return get_next_input()
end
location.std.checkers[1].dynamic = function(ct)
  return get_next_in_out()
end
location.std.checkers[2].dynamic = function(ct)
  return get_rod(get_value(ct))
end
local open_time = 0
location.std.checkers[2].spec = {
  condition_override = function()
    if open_time > 0 then
      open_time = open_time - 1
      return "open"
    end
    local offset = location.std.checkers[2].check.greater - location.std.checkers[2].mirror_source.greater
    local x = get_simple_connected_component(nil, location.std.checkers[2].mirror_source.greater).found; --can't fail
    local y = get_simple_connected_component(nil, location.std.checkers[2].check.greater);
    if y.flag == "ok" and grid_offset_cmp(x, y.found, offset) then
      local ct = 0;
      for vec, _ in grid_pairs(x) do
        local b1 = game:at(vec)
        local b2 = game:at(vec + offset)
        assert(b1 and b2)
        if not compare_blocks(b1, b2) then
          return "reject"
        end
        ct = ct + 1
      end
      open_time = ct - 1
      return "accept"
    end
    return "reject";
  end
}

local generate_sequence = {5, 4, 1, 5, 2, 4, 5, 1, 4, 2, 1, 3, 4, 3, 4, 3, 1, 2, 4, 3, 3, 2, 1, 2, 2, 1, 4, 3, 2, 3, 3, 4, 5, 5, 1, 4, 2, 1, 5, 2, 5, 3, 5, 4, 4, 3, 5, 1, 1, 3};
function get_value(idx)
  return generate_sequence[(idx % #generate_sequence) + 1]
end
